// Cours ELE732 - Lab3
// Par: 	Frederic Morin (MORF09107807)
// Modifi: Eric Thibodeau (THIE17057907)
// 
// Paramtres:
// lab3_v2 n m nPas td h a
//
// n: 	 Lagrgeur de la plaque
// m: 	 Longueur de la plaque
// nPas: Nombre de pas  itrer 
// td:	 Taux d'chantillonage (Pas)
// h:	 ??
// a:	 0 = aucun affichage
// 		 1 = affichage de laplaque de dpart et celle refroidie
// 		 2 = affichage du temps d'excution dans le format:
// 		 	 Temps exec:, [n],[Temps d'excution]
// 		 	 Note: cet affichage est utilis pour collecter des statistiques et n'est
// 		 	 utile que pour des plaques carres o N=M.
// 
// Ligne de commande pour plusieurs itrations (grandeur fixe de 12 12):
// $ for NM in `seq 0 5`; do mpirun -np 4 lab3_v2 12 12  200 0.0002 0.083333333333333333333333333333333 1 >> 1212.txt; done
// 
// Ligne de commande pour plusieurs itrations:
// $ for NM in `seq 5 200`; do mpirun -np 4 lab3_v2 $NM $NM 200 0.0002 0.083333333333333333333333333333333 2 >> rslt.csv; done
//

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <sys/time.h>
#include "mpi.h"

void sendArgs(void);
void initialisation(void);
void affichage(void);
void execution(void);
void synchro(void);
void RebuildPlaque(void);

//variables pour les arguments de ligne de commande et les constantes de calculs qui en decoulent
int    n, m, nPas , a;
double td, h, h2,c1, c2;
float args[6];

double *PlaqueNow;
double *PlaqueNext;
int TableSize;

MPI_Status status;
MPI_Request request1,request2;
int np,ProcID,LastProc,Tdiv,Tbottom;
const int racine = 0;
const int suivant = 10;
const int precedant = 20;

// Variables pour timestamp
double	timeStart, timeEnd,Texec;
struct	timeval tp;
// Variables pour timestamp FIN


int main (int argc, char *argv[])
{

	int i,j,k;
	int err;

		
	err = MPI_Init(&argc, &argv);
	if (err != MPI_SUCCESS)
	{
		printf("MPI initialization failed!\n");
		exit(1);
	}
	err = MPI_Comm_size(MPI_COMM_WORLD, &np);
	err = MPI_Comm_rank(MPI_COMM_WORLD, &ProcID);

	if(ProcID==0)
	{
		n = atoi(argv[1]); 
		m = atoi(argv[2]); 
		nPas = atoi(argv[3]);
		td = atof(argv[4]);
		h = atof(argv[5]);
		a = atoi(argv[6]);
	}
	
	sendArgs();

	initialisation();

	if(ProcID==0)
	{
		
		if (a==1) affichage();

		// Timestamp pour calculer de temps d'excution
		gettimeofday (&tp, NULL);	// Dbut du chronomtre
		timeStart = (double) (tp.tv_sec) + (double) (tp.tv_usec) / 1e6;
		// Timestamp FIN
	}

//C'est ici que tout se calcule...
	for(k=0;k<nPas;k++)
	{
		execution();
		synchro();
	}
	
//recuperation des donnes de chaque processus
	RebuildPlaque();

	if (ProcID == 0)
	{
		// Timestamp pour calculer de temps d'excution
		gettimeofday (&tp, NULL);	// Fin du chronomtre
		timeEnd = (double) (tp.tv_sec) + (double) (tp.tv_usec) / 1e6;
		Texec = timeEnd - timeStart;	 //Temps d'excution en secondes
		// Timestamp FIN

		affichage();

	}
	
	err = MPI_Finalize();
	return 0;
}

void initialisation(void)
{
	int i,j,k,k_start,TableSizeDouble,LigneDebut,LigneFin;
	
//Initialisation de certaines variabnles de calculs
	h2=h*h;
	c1 = (1 - 4 * td / h2);
	c2 = (td / h2);

	LastProc = np-1;
	Tdiv = n/np;
	if( n%np ) Tbottom = n%np;
	else       Tbottom = Tdiv;

//parallelisation
	if(ProcID == 0) 
		TableSize = m*n;			 // la plaque au complet
	else if (ProcID == LastProc)  
		TableSize = m*(Tdiv+1);	 // +1 overlap
	else
		TableSize = m*(Tdiv+2);  // +2 overlap
//parallelisation--FIN
			
	TableSizeDouble = TableSize*sizeof(double);
	
	PlaqueNow  = malloc(TableSizeDouble);
	PlaqueNext = malloc(TableSizeDouble);

	memset(PlaqueNow ,0,TableSizeDouble);
	memset(PlaqueNext,0,TableSizeDouble);
	

//parallelisation
	 k_start=0;
	 LigneDebut = ProcID*Tdiv-1;

	 if ( ProcID == 0 )
	 {
		 k_start=1;
		 LigneDebut = 1;
		 LigneFin = n-1;
	 }
	 else if (ProcID == LastProc)
		 LigneFin = (ProcID)*Tdiv+Tbottom-1; //garder la derniere ligne a 0
	 else
		 LigneFin = (ProcID+1)*Tdiv;
//parallelisation--FIN

//Inisialisation des plaques
	 for(k=k_start,j = LigneDebut; j <= LigneFin; k++,j++)
		 for(i = 1; i < (m-1); i++) //les marges gauches et droites seront toujours a leur valeur initiale (0)
			 PlaqueNow[k*m+i] = i*(m-i-1)*j*(n-j-1);
		 
	memcpy(PlaqueNext,PlaqueNow,TableSizeDouble);	//les deux plaques commencent a la meme temperature
}

void affichage(void)
{
  int i,j,LigneDebut,LigneFin;

	LigneDebut = ProcID*Tdiv-1;

//parallelisation
	if ( ProcID == 0 )
	{
		LigneDebut = 0;
		LigneFin = n;
	}
	else if (ProcID == LastProc)
		LigneFin = Tbottom+1; //garder la derniere ligne a 0
	else
		LigneFin = Tdiv+2;
//parallelisation--FIN

	if(a == 1) //affichage des resultats en tableau
	{
	 for(j = 0; j < LigneFin; j++)
	 	{
//			printf("PID:%d %d: ",ProcID,j); //DEBUG
			for(i = 0; i < m; i++)
				{
					printf(" %3.01f", PlaqueNow[j*m+i]);
				}
			printf("\n");
		}
	}
	else if(a == 2) //affichage des statistiques
		printf("Temps exec:,%d,%d,%f\n",n,nPas,Texec);
}

void execution(void)
{
	int i,j,Last;
	double * dptr;
	
	if (ProcID == LastProc) Last = Tbottom-1;
	else                     Last = Tdiv;
	
	for(j=1 ; j <= Last ;j++)
		for(i=1;i<(m-1);i++)
		{
			PlaqueNext[j*m+i] = 
			c1 * PlaqueNow[j*m+i] +
			c2 * 
			(
	   		PlaqueNow[m*j+i-1]  +	//gauche
	   		PlaqueNow[m*j+i+1]  +	//droite
	   		PlaqueNow[m*(j-1)+i]+	//haut
	   		PlaqueNow[m*(j+1)+i]    //bas
			);
		}
	
	// Les calculs finis, on redefinis les pointeurs pour refleter la realite
	dptr = PlaqueNow;
	PlaqueNow = PlaqueNext;
	PlaqueNext = dptr;

}

void synchro(void)
{		
	// On synchronise les lignes "overlap"
	// Top et Bottom envoient avant de recevoir, les plaques centrales recoivent avant d'envoyer...
	
	if(ProcID==0) //Top
	{
		//Tx/Rx du bas
		MPI_Send(PlaqueNow+m*(Tdiv-1), m, MPI_DOUBLE, ProcID+1, suivant, MPI_COMM_WORLD);
		MPI_Recv(PlaqueNow+m*Tdiv    , m, MPI_DOUBLE, ProcID+1, suivant, MPI_COMM_WORLD, &status);
	}
	else if(ProcID==LastProc) //bottom
	{
		//Tx/Rx du haut
		MPI_Send(PlaqueNow+m, m, MPI_DOUBLE, ProcID-1, suivant, MPI_COMM_WORLD);
		MPI_Recv(PlaqueNow  , m, MPI_DOUBLE, ProcID-1, suivant, MPI_COMM_WORLD, &status);
	}
	else	// plaques intermediaires
	{
		// Tx du haut et du bas
		MPI_Send(PlaqueNow+m     , m, MPI_DOUBLE, ProcID-1, suivant, MPI_COMM_WORLD);
		MPI_Send(PlaqueNow+m*Tdiv, m, MPI_DOUBLE, ProcID+1, suivant, MPI_COMM_WORLD);

		// Rx du haut et du bas
		MPI_Recv(PlaqueNow           , m, MPI_DOUBLE, ProcID-1, suivant, MPI_COMM_WORLD, &status);
		MPI_Recv(PlaqueNow+m*(Tdiv+1), m, MPI_DOUBLE, ProcID+1, suivant, MPI_COMM_WORLD, &status);
	}

//synchro
//	mis en commentaire, s'avere etre innutile
//	MPI_Barrier(MPI_COMM_WORLD);

}

void RebuildPlaque(void)
{
int i;
	if(ProcID==0) //Top
	{
		for (i=1;i < np-1;i++)
			MPI_Recv(PlaqueNow+m*(Tdiv*i), m*Tdiv   , MPI_DOUBLE, i, suivant, MPI_COMM_WORLD, &status);
		MPI_Recv(PlaqueNow+m*(Tbottom*i), m*Tbottom, MPI_DOUBLE, np-1, suivant, MPI_COMM_WORLD, &status);
	}
	else if(ProcID==LastProc) //bottom
	{
			MPI_Send(PlaqueNow+m, m*Tbottom, MPI_DOUBLE, 0, suivant, MPI_COMM_WORLD);
	}
	else	// plaques intermediaires
	{
			MPI_Send(PlaqueNow+m, m*Tdiv, MPI_DOUBLE, 0, suivant, MPI_COMM_WORLD);
	}	
}

void sendArgs(void)
{
int i;
// Param 12 12 200 0.0002 0.083333333333333333333333333333333 0
	if(ProcID == 0)
	{
		args[0]=n;
		args[1]=m;
		args[2]=nPas;
		args[3]=td;
		args[4]=h;
		args[5]=a;
		
		for (i=1;i < np;i++)
			MPI_Send(args, 6, MPI_FLOAT, i, suivant, MPI_COMM_WORLD);	
	}
	

	if(ProcID != 0)
	{
		MPI_Recv(args, 6, MPI_FLOAT, racine, suivant, MPI_COMM_WORLD, &status);
		n=(int)args[0];
		m=(int)args[1];
		nPas=(int)args[2];
		td=args[3];
		h=args[4];
		a=(int)args[5];
	}
}
