// Cours ELE732 - Lab1
// Par: 	Frederic Morin (MORF09107807)
// Modifi: Eric Thibodeau (THIE17057907)
// 
// Paramtres:
// progExe n m nPas td h a
//
// n: 	 Lagrgeur de la plaque
// m: 	 Longueur de la plaque
// nPas: Nombre de pas  itrer 
// td:	 Taux d'chantillonage (Pas)
// h:	 ??
// a:	 0 = aucun affichage
// 		 1 = affichage de laplaque de dpart et celle refroidie
// 		 2 = affichage du temps d'excution dans le format:
// 		 	 Temps exec:, [n],[Temps d'excution]
// 		 	 Note: cet affichage est utilis pour collecter des statistiques et n'est
// 		 	 utile que pour des plaques carres o N=M.
// 
// Ligne de commande pour plusieurs itrations (grandeur fixe de 12 12):
// $ for NM in `seq 0 5`; do ./sequentiel 12 12  200 0.0002 0.083333333333333333333333333333333 1 >> 1212.txt; done
// 
// Ligne de commande pour plusieurs itrations:
// $ for NM in `seq 5 200`; do ./sequentiel $NM $NM  200 0.0002 0.083333333333333333333333333333333 2 >> rslt.csv; done
//

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include <sys/time.h>

int main (int argc, char *argv[]){
	
	// Variables pour timestamp
	double	timeStart, timeEnd, Texec;
	struct	timeval tp;
	// Variables pour timestamp FIN

	double c1;
	double c2;
	
	double *plaque;
	double *vieillePlaque;
	double *ptr[2];

	int n;
	int m;
	int nPas;
	double td;
	double h, h2;
	int a;

	int i,j,k;
	int toggle;
	toggle = 0;

	

	if(argc != 7){
		printf("Il manque des arguments");
		return(0);
	}else{
// Param 12 12 200 0.0002 0.083333333333333333333333333333333 0
		n = atoi(argv[1]);
		m = atoi(argv[2]);
		nPas = atoi(argv[3]);
		td = atof(argv[4]);
		h = atof(argv[5]);
		a = atoi(argv[6]);

		h2=h*h;

		c1 = (1 - 4 * td / h2);
		c2 = (td / h2);

		plaque = malloc(n*m*sizeof(double));
		vieillePlaque = malloc(n*m*sizeof(double));

		ptr[0] = vieillePlaque;
		ptr[1] = plaque;

		memset(vieillePlaque,0,n*m*sizeof(double));
		memset(plaque,0,n*m*sizeof(double));


// ---------- Initialisation de la temprature de la plaque 		
		for(j = 0; j < n; j++){
			for(i = 0; i < m; i++){
				if (i == 0 || j == 0){
					*vieillePlaque = 0;
				}
				else{
					*vieillePlaque = i*(m-i-1)*j*(n-j-1);
				}
				vieillePlaque++;
			}
		}
// ---------- Initialisation de la temprature de la plaque FIN

		vieillePlaque = ptr[toggle];

// ---------- Affichage de la temprature initiale
		if(a == 1){
			for(j = 0; j < n; j++){
				for(i = 0; i < m; i++){
					printf(" %0.02f", *vieillePlaque);
					vieillePlaque++;
				}
				printf("\n");	
			}
		}

		// On fait le changement de plaque en changeant les pointeurs de ceux-ci
		vieillePlaque = ptr[toggle];

		
// ---------- Algorythme de calcul de la temprature

		// Timestamp pour calculer de temps d'excution
		gettimeofday (&tp, NULL);	// Dbut du chronomtre
		timeStart = (double) (tp.tv_sec) + (double) (tp.tv_usec) / 1e6;
		// Timestamp FIN
		
/* optimisations: 
-->1: sortir (1-4*td/h2) --> c1 et (td/h2) --> c2 de la boucle de calcul, ce sont des constantes. 
			Resultat de cette optimisation: passe de 33.33 secondes a 26.17 secondes!
	
	2: transformer l'algorythme de pointeurs de (*ptr+(i+j)) pour ptr[i+j]
			Resultat de cette optimisation: _AUCUNE OPTIMISATION_ d'execution (esthetique de code)
	
	3: Eviter l'utilisation de variables globales comme indexes de boucles. S'assurer que celles-ci	sont chargees dans les registres
			Resultat de cette optimisation: passe de 26.17 secondes a 25.84 secondes...donc NEGLIGEABLE

-->4: Le compilateur utilise pour MPI n'est pas gcc... tenter d'utiliser les optimisations gcc pour ameliaurer les performances. Compiler avec gcc -O2
			Resultat: EUREKA! La clef etait dans l'optimisation de code: Le temps d'execution passe de 25.84
			a 2.588 secondes! Ce qui est meme 2x plus rapide que l'execution parallele avec 2 processeurs
			utilisant la librairie MPI (mpirun -np 2).
			Les details sur les options d'optimisation du compilateur gcc sont situes au site web: gcc.gnu.org
			(	http://gcc.gnu.org/onlinedocs/gcc-3.3.4/gcc/Optimize-Options.html#Optimize%20Options )
	
	Regression:
		Pour que les donnes soient comparables, nous avons recompile l'application avec mpicc. Le temps
		d'execution excellent de gcc est donc passe de 2.588 secondes a 7.45 secondes.
*/
	{
		register int i,j,k;
		register double * dptrToggle;
		
		for(k = 0; k < nPas; k++){
			for(j = 1; j < n-1; j++){
				for(i = 1; i < m-1; i++){
//					*(plaque+((m*j)+i)) = (1-4*td/h2) * (*(vieillePlaque+((m*j)+i)))
					plaque[m*j+i] = c1 * vieillePlaque[m*j+i]
//						+ (td/h2)*( (*(vieillePlaque+((m*j)+i-1))) 
						+ c2*( vieillePlaque[m*j+i-1]
//						+ (*(vieillePlaque+((m*j)+i+1))) 
						+ vieillePlaque[m*j+i+1] 
//						+ (*(vieillePlaque+((m*(j-1))+i))) 
						+ vieillePlaque[m*(j-1)+i]
//						+ (*(vieillePlaque+((m*(j+1))+i)))  );
						+ vieillePlaque[m*(j+1)+i] );
				}
			}
/*			toggle = !toggle;
			vieillePlaque = ptr[toggle];
			plaque = ptr[!toggle];
*/			dptrToggle = vieillePlaque;
			vieillePlaque = plaque;
			plaque = dptrToggle;

		}
	}
// ---------- Algorythme de calcul de la temprature FIN

		// Timestamp pour calculer de temps d'excution
		gettimeofday (&tp, NULL);	// Fin du chronomtre
		timeEnd = (double) (tp.tv_sec) + (double) (tp.tv_usec) / 1e6;
		Texec = timeEnd - timeStart;	 //Temps d'excution en secondes
		// Timestamp FIN
		
// -----------  Affichage -------------		
		if(a == 1){
			printf("\n\n");
			for(j = 0; j < n; j++){
				for(i = 0; i < m; i++){
					printf(" %0.02f",  *vieillePlaque);		
					vieillePlaque++;
				}
				printf("\n");	
			}
			printf("Temps exec:,%d,%d,%f\n\n",n,nPas,Texec);
			
		}
		else if(a == 2)
		{
			printf("Temps exec:,%d,%d,%f\n",n,nPas,Texec);
		}
// -----------  Affichage Fin ---------	
	}
	return 0;
}

