#!/bin/bash
MAIL_TO="kyron@neuralbs.com "
OUTPUT="cat"
if [[ $1 == "-m" ]]
then
	OPT1=$1
	shift
fi

if [[ $# == 0 ]]
then
	LASTLOG=/var/log/maillog.12
	LOGS="/var/log/maillog.*"
else
	LASTLOG=${!#} #derniers argument en ligne de commande
	LOGS="$@"
fi

SINCE=$(head -n1 $LASTLOG | tr -s ' ' | cut -d ' ' -f1-3)
UNTIL=$(tail -n1 /var/log/maillog | tr -s ' ' | cut -d ' ' -f1-3)
#sSINCE=`date -d"$SINCE" +%s` # En secondes pour faire un "range"
#sUNTIL=`date -d"$UNTIL" +%s`
TITLE="Spam Statistics from $SINCE to $UNTIL"

[[ $OPT1 ]] &&	OUTPUT="eval mail -s '$TITLE' $MAIL_TO"

awk -v TITRE="$TITLE" '
BEGIN{ print TITRE }

$5 !~ /smtpd/		{ next  } # Skip all that has nothing to do with smtpd
#/: connect from/	{ REC++ }
/client=/			{ REC++ }
/reject:/			{ BAD++ }

END{
	print "Received:",REC," 100 %"
	print "Rejected:",BAD,BAD/REC*100,"%"
	print "Accepted:",REC-BAD,(REC-BAD)/REC*100,"%"
}
' $LOGS | $OUTPUT
