#!/bin/bash
# Author: Eric Thibodeau May 2006, feel free to re-distribute ;)
#
shopt -s xpg_echo

ROOT=${1}
# Source make.conf to get PORTDIR_OVERLAY
source /etc/make.conf
MOUNTS="${PORTDIR_OVERLAY} /usr/portage" 


if [ $# -lt 1 ]
then
	echo "Usage: $0 <Path to CHROOT environemnt>"
	exit 1
fi

if [ ! -d ${ROOT} ]
	then echo "${ROOT} is not a directory, exiting"
	exit 1
fi

## Calls unmount on all $MOUNTS
function unmounts(){
    for I in ${MOUNTS}
    do
        umount -v ${ROOT}${I} 
   done
	umount -v ${ROOT}/proc
	umount -v ${ROOT}/sys
}

## Calls mount on all $MOUNTS
function mounts(){
	for I in ${MOUNTS}
	do
		if [ ! -d ${ROOT}${I} ]; then
			echo "WARNING! Silently creating missing destination folder!!!"
			echo "Adding ${ROOT}${I}"
			mkdir -p ${ROOT}${I}
		fi
		
		mount -v -o bind,noatime ${I} ${ROOT}${I} 
		if [ $? != 0 ]; then 
			echo "Unable to mount ${ROOT}${I}, exiting!"
			unmounts
			exit 1
		fi
	done
	mount -t proc none ${ROOT}/proc
	mount -o bind /sys ${ROOT}/sys
}

mounts
cp -Lf /etc/resolv.conf ${ROOT}/etc/resolv.conf
echo "\nChrooting into the ${ROOT} environment, don't forget to run:\n"
echo "env-update && source /etc/profile && PS1='\[\\\\033[01;31m\]${ROOT}\[\\\\033[01;34m\] \W \\$\[\\\\033[00m\] '"

if [ `uname -m` = "x86_64" ]; then
	linux32 chroot ${ROOT} /bin/bash
else 
	chroot ${ROOT} /bin/bash
fi

unmounts
