#!/bin/bash
shopt -s xpg_echo

echo Scanning for vulnerable packages...
PKG_LIST=`glsa-check -nl 2> /dev/null |grep '[0-9] \[N'`

if [ -z "$PKG_LIST" ]
then
        echo "There are no packages in the GLSA listing (your system is not knowingly vulnerable)"
else
        echo 'One or more vulnerable package(s) found!!!'
        echo "$PKG_LIST"
        echo Generating update list
        glsa-check -p `echo "$PKG_LIST" | grep -o -e"[0-9]*-[0-9]*\ "` 2> /dev/null 
		echo "Perform the updates?\c"
		while :
		do
			echo " Y or N:\c"
			read ANS
			case $ANS in
				y|Y) glsa-check -f `echo "$PKG_LIST" | grep -o -e"[0-9]*-[0-9]*\ "` 2> /dev/null; exit ;;
				n|N) echo "Quitting!!"; exit;;
				*) echo;;
			esac
		done
fi

exit 0

