#!/bin/bash
# author: Mike Snitzer <msnitzer@plogic.com>
# Modified by Eric Thibodeau to adapt to the Gentoo reality (removed module loading)
# desc:   used to make lm_sensors metrics available to ganglia

# WARNING: Before usign this script, make sure your sensors output is clean (see output below)
# This is important since the labels will be used to send data values and labels _and_ units to 
# the ganglia monitoring agent.

GMETRIC=/usr/bin/gmetric
#GMETRIC="echo /usr/bin/gmetric" # for debugging
SENSORS=/usr/bin/sensors

# Single command line. this takes for granted that the /etc/sensors.conf has an intelligent
# naming scheme to help parsing so that sensors would return sensor names with no spaces.
# For example:
#
#thinkbig13 scripts # sensors
# asb100-i2c-0-2d
#Adapter: SMBus Via Pro adapter at e800
#
#VCore_1:   +1.70 V  (min =  +1.31 V, max =  +1.97 V)
#+3.3V:     +3.33 V  (min =  +2.96 V, max =  +3.63 V)
#+5V:       +4.84 V  (min =  +4.49 V, max =  +5.51 V)
#+12V:     +12.46 V  (min =  +9.55 V, max = +14.41 V)
#-12V:     -13.09 V  (min =  -0.00 V, max =  -0.00 V)
#-5V:       -5.46 V  (min =  -0.00 V, max =  -0.00 V)
#CPU_Fan:  4299 RPM  (min =   -1 RPM, div = 2)
#M/B_Temp:    +33°C  (high =   +80°C, hyst =   +75°C)
#CPU_Temp:    +66°C  (high =   +80°C, hyst =   +75°C)
#vid:      +1.650 V  (VRM Version 9.0)
#alarms:

# tr and awk then parse the output and automatically calls gmetric according to the sensor.
# For awk, $1 == label; $2 == Value; $3 == 
sensors | tr -s " " | awk 'BEGIN{FS="(:| |°|	)"} /\(/ {print $1,$2,$3,$4}' | while read LABEL VAL UNIT
do
	case $LABEL in
		*Fan)	TYPE="uint32";;
		*)		TYPE="float"
	esac
	$GMETRIC -t $TYPE -n "$LABEL" -u "$UNIT" -v "${VAL#+}"
done

exit 0
