#!/bin/bash
if ((  $# < 2 ))
then
	echo "Usage: $0 <libname> <DependantPackageListFileName>"
	echo "Example: $0 libstdc++.so.5 PackagesToRebuild.list"
	exit 1
fi

rm -f DependantBin

# we expect all bindirs to be in the $PATH

for I in $(find $(echo $PATH|tr : "\n"|grep bin|uniq) -xtype f -perm +111)
do 
	ldd "$I" | grep -s "$1"
	if (( $? == 0 ))
	then
		echo "$I" >> DependantBin
	fi
done

for I in $(cat DependantBin)
do
	equery -q -C belongs -e "$I" | sed -e's:-[0-9].*::' >>$2
done

cat $2 | sort | uniq > ${2}.uniq
mv ${2}.uniq $2

echo "Package list dependant on $1 listed in $2"
