#!/bin/bash
# Eric Thibodeau (built with -fno-coding-elegance)
# NOTICE:
# There is ABSOLUTELY no reson to trust my scripts even less use them!...You've been warned!
# Why I made this script:
# gimme.rb doesn't take multiple packages on the command line and I want to keep my unmasking easy, package/version specific
#
# paludis --show-reasons summary --continue-on-failure if-independent --log-level warning -pi --compact `cat world` > ~/Paludis.out 2>&1
# Then:
# for I in `egrep '\[! masked\]' ~/Paludis.out | cut -d\  -f2| sort | uniq | tr '\n' ' '`; do ./gimme.rb --pretend --use-subdir yes --match-type equal $I; done
TMPFILE=~/$$.tmp

# No command line options
if [[ $# == 0 ]]; then
	echo -e "USAGE:\n $0 [pac-kage/name|name] <option to gimme.rb>\n"
	echo -e "\ngimme.rb options are (--use-subdir yes --match-type equal is set by default!):\n"
	./gimme.rb --help
	exit 1;
fi

echo "Building masked package list"
touch ${TMPFILE}
paludis --show-reasons summary --continue-on-failure if-independent --log-level warning -pi --compact $1 > ${TMPFILE} 2>&1

# the rest of the args go to gimme.rb
shift 

echo "The following were masked and gimme.out will take care of them ;) :"
egrep '\[! masked\]' ${TMPFILE}

for I in `egrep '\[! masked\]' ${TMPFILE} | cut -d\  -f2 | sort | uniq | tr '\n' ' '`
do 
	echo "calling ./gimme.rb --use-subdir yes --match-type equal $@ $I "
	./gimme.rb --use-subdir yes --match-type equal $@ $I
done
rm ${TMPFILE}
