#!/bin/bash
# Eric Thibodeau Nov. 2007
# Feel free to redistribute but don't blame me for your broken system ;)
# Not a UBD-safe script, read it if you want to use it!
ARCH=amd64

if [[ $# != 1 ]]
then
	echo "Usage:
Call the script with the version of the package you want, ie:
$0 =cat-egory/pack-age-0.1.2.3

$0 will _recursively_ call emerge to resolve packages to unmask.
(It's HORRIBLE, I don't know python yet!)

NOTE: the scripts automatically selects the HIGHEST MATCHING package
to unmask/unkeyword.
"
	exit 0;
fi

# BUG
# We have to TRAP here to delete the temp files on cancel
shopt -s xpg_echo 

[[ ${1} =~ .*/(.*)-[0-9].* ]]
PKG_NAME=${BASH_REMATCH[1]}

# Unmask and Keyword files
UMF=/etc/portage/package.unmask/${PKG_NAME}
KWF=/etc/portage/package.keywords/${PKG_NAME}

function clean()
{
	echo "Deleting $UMF and $KWF\n"
	rm -f $UMF
	rm -f $KWF
}

function mergecall()
{
	echo "Calling emerge -aqvN on ${1}\n"
	emerge -aqvN ${1}
}

function env_check()
{
	if [[ -f /etc/portage/package.unmask || -f /etc/portage/package.keywords ]]
	then
		for I in /etc/portage/package.{unmask,keywords} ; do mv $I $I. ; mkdir $I; mv $I. $I/$(basename $I).old; done
	elif [[ ! -d /etc/portage/package.unmask || -d /etc/portage/package.keywords ]]
	then
		mkdir -p /etc/portage/package.unmask
		mkdir -p /etc/portage/package.keywords
	fi
}

env_check

[[ ${1} =~ .*/(.*)-[0-9].* ]]
PKG_NAME=${BASH_REMATCH[1]}

DONE="FALSE"
while [[ $DONE == "FALSE" ]]
do
	OUT=`emerge ${1} -pq`
	echo "$OUT" | grep -q '!!! All ebuilds that could satisfy'
	if [[ $? == 0 ]]
	then
		MERGE_ME=`echo "$OUT" | egrep '^-' | tail -n1 | cut -d" " -f2 `
		echo "I need to force merge of : =$MERGE_ME"
		echo =$MERGE_ME      >> $UMF
		echo "=$MERGE_ME **" >> $KWF
	else
		echo "Done building unmask/arch tree!"
		DONE=TRUE
	fi
done

if [[ ! -z $MERGE_ME ]]
then
	echo "\nThese are the packages that would be added to \n
$UMF 
and
$KWF\n
`cat $UMF`"

	echo -n "\nDo you really want to proceed [Y(es)/N(o)]?: "
	read ANS
	if [[ "N" == $ANS || "n" == $ANS ]] 
	then
		clean
		exit 0;
	elif [[ "y" == $ANS || "Y" == $ANS ]]
	then
		echo "Calling emerge -aqvN on ${1}\n"
		mergecall ${1}
	fi
else
	echo "This package doesn't require masked/keyworded packages\n"
	mergecall ${1}
fi


