#!/bin/bash -x
#Day on which the full backup runs (on a weekly basis)
FULL_BACKUP_DAY=6

TAPEDEV="/dev/nosst0"
MT_COM="mt -f $TAPEDEV"

MAILTO="kyron@jrtad.com,jrobert@jrtad.com"

INCLUDE="/files/"
INCR_INCLUDE="/files/jrtad.com/"
EXCLUDE="/files/Kyron/MP3"

TAR_COM="{ tar -c --exclude=$EXCLUDE -vvf - $INCLUDE |buffer -s 32k -m 24M -p 75 -B -t -o /dev/nosst0; }"

#Getting temporal variables (when are we!!? :-)
TODAY=`date +%w`     		#day of week (0..6);  0 represents Sunday
NOW=`date +%y-%m-%d_%H-%M`
RET=0

function error {
	mail -s "ERROR during backup in command $1" $MAILTO < /backups/log/full.log
exit 1
}
function report {
	mail -s "$1 backup report for `date`" $MAILTO < $2
exit 0
}

function tape {
	echo "[`date`] $MT_COM $1 called --> $2" 2>&1 >> /backups/log/full.log
	$MT_COM $1
	RET=$?
	if [ "$RET" -ne "0" ]; then
		echo "[`date`] $MT_COM $1 returned $RET" 2>&1 >> /backups/log/full.log
		error $1
	fi
}

function tartotape {
	echo "[`date`] $TAR_COM called" 2>&1 >> /backups/log/full.log
	{ tar -c --totals --exclude=$EXCLUDE -vvf - $INCLUDE \
	|buffer -s 32k -m 24M -p 75 -B -t -o /dev/nosst0; } &> /backups/log/$NOW.tar.log
	RET=$?
    if [ "$RET" -ne "0" ]; then
        echo "[`date`] tar returned $RET" 2>&1 >> /backups/log/full.log
        echo "********begining of tar log**********" >> /backups/log/full.log
		cat /backups/log/$NOW.tar.log >> /backups/log/full.log
		echo "********end of tar log***************" >> /backups/log/full.log
		error tar
    fi

	echo "[`date`] Backup completed succesfully!" >> /backups/log/full.log
	tail -n2 /backups/log/$NOW.tar.log >> /backups/log/full.log
}

function full {
	rm -f  /backups/log/full.log
	tape retension "Retensioning the tape"
	tape erase "Guess!!! :-)"
	tartotape
	tape rewoffl "Rewinding and ejecting the tape...GO GRAB IT!"
	report "Week #`date +%U` Full" "/backups/log/full.log"
}

function incremental {
 
{ find $INCR_INCLUDE -type f -newer /backups/log/full.log -print | tar --totals -cvvf /backups/incremental/$NOW.tar -T -; } &>/backups/log/incremental.$NOW.log

report Incremental "/backups/log/incremental.$NOW.log"
}

if [ "$TODAY" = "$FULL_BACKUP_DAY" ]; then
	full;
else
	incremental;
fi

